<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class Elementor_Image_Comparison_Widget extends Widget_Base {

    public function get_name() {
        return 'image-comparison-widget';
    }

    public function get_title() {
        return __( 'Image Comparison', 'image-comparison-widget' );
    }

    public function get_icon() {
        return 'eicon-image-before-after';
    }

    public function get_categories() {
        return [ 'basic' ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'plugin-name' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __( 'Background Image', 'plugin-name' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'foreground_image',
            [
                'label' => __( 'Foreground Image', 'plugin-name' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slider_position',
            [
                'label' => __( 'Slider Position', 'plugin-name' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="acontainer">
            <div id="comparison">
                <figure style="background-image: url('<?php echo esc_url($settings['background_image']['url']); ?>');">
                    <div id="handle"></div>
                    <div id="divisor" style="background-image: url('<?php echo esc_url($settings['foreground_image']['url']); ?>');"></div>
                </figure>
                <input type="range" min="0" max="100" value="<?php echo esc_attr($settings['slider_position']['size']); ?>" id="slider" oninput="moveDivisor()">
            </div>
        </div>
        <?php
    }

    protected function _content_template() {
        ?>
        <#
        var bgImage = settings.background_image.url;
        var fgImage = settings.foreground_image.url;
        var sliderPos = settings.slider_position.size;
        #>
        <div class="acontainer">
            <div id="comparison">
                <figure style="background-image: url('{{ bgImage }}');">
                    <div id="handle"></div>
                    <div id="divisor" style="background-image: url('{{ fgImage }}');"></div>
                </figure>
                <input type="range" min="0" max="100" value="{{ sliderPos }}" id="slider" oninput="moveDivisor()">
            </div>
        </div>
        <?php
    }
}
