<?php
/**
 * Plugin Name: Before | After picture slider
 * Description: Slider that show before and after on a picture
 * Plugin URI:  https://standigital.lv
 * Version: 1.0
 * Author: StanDigital
 * Author URI: https://standigital.lv
 * Text Domain: image-comparison-elementor-widget
 *
 * Elementor tested up to: 3.19.3
 * Elementor Pro tested up to: 3.19.3
 */
 
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Register Widget
function register_image_comparison_widget( $widgets_manager ) {
    require_once( __DIR__ . '/widgets/image-comparison-widget.php' );
    $widgets_manager->register( new \Elementor_Image_Comparison_Widget() );
}
add_action( 'elementor/widgets/register', 'register_image_comparison_widget' );

// Enqueue Scripts and Styles
function enqueue_image_comparison_widget_scripts() {
    wp_enqueue_style( 'image-comparison-widget-style', plugins_url( 'style.css', __FILE__ ) );
    wp_enqueue_script( 'image-comparison-widget-script', plugins_url( 'script.js', __FILE__ ), array('jquery'), false, true );
}
add_action( 'wp_enqueue_scripts', 'enqueue_image_comparison_widget_scripts' );